package game;

import java.awt.Color;
import java.awt.Graphics;


public class SolidBlockSprite implements BlockInterface {
	
	private int xPos;
	private int yPos;
	
	private CustomImageDataII image;
	
	private int width;
	private int height;
	
	private boolean isPassThrough;
	
	private IntRect collisionRect;
	
	private int rectMinY;
	private int rectMaxY;
	
	private int rectMinX;
	private int rectMaxX;
	
	public SolidBlockSprite(boolean isResource, String resourceName, int theWidth, int theHeight, int xPosition, int yPosition, Color transparency, boolean passThru, PonyPanel ponyPanel) {
		
//		ImageIcon icon = new ImageIcon(SolidBlockSprite.class.getResource(resourceName));
		
//		image = new CustomImageData(icon.getImage(), theWidth, theHeight, transparency, ponyPanel);
		image = new CustomImageDataII(resourceName, transparency, ponyPanel);
		
		width = theWidth;
		height = theHeight;
		
		xPos=xPosition;
		yPos=yPosition;
		
		isPassThrough = passThru;
		
		collisionRect = new IntRect(xPos - width/2, yPos - height/2, width, height);
		rectMinY = (int) collisionRect.getMinY();
		rectMaxY = (int) collisionRect.getMaxY();
		
		rectMinX = (int) collisionRect.getMinX();
		rectMaxX = (int) collisionRect.getMaxX();
		
	}
	
	
	public SolidBlockSprite(CustomImageDataII theImage, int theWidth, int theHeight, int xPosition, int yPosition, boolean passThru) {
		
		image = theImage;
		
		width = theWidth;
		height = theHeight;
		
		xPos=xPosition;
		yPos=yPosition;
		
		isPassThrough = passThru;
		
		collisionRect = new IntRect(xPos - width/2, yPos - height/2, width, height);
		rectMinY = (int) collisionRect.getMinY();
		rectMaxY = (int) collisionRect.getMaxY();
		rectMinX = (int) collisionRect.getMinX();
		rectMaxX = (int) collisionRect.getMaxX();
		
	}
	
	/* (non-Javadoc)
	 * @see BlockInterface#getCollisionRect()
	 */
	@Override
	public IntRect getCollisionRect() {
		return collisionRect;
	}
	
	/* (non-Javadoc)
	 * @see BlockInterface#isPlayerSpriteBlocked(PlayerSprite)
	 */
	@Override
	public boolean isPlayerSpriteBlocked(CollidableObject player) {
		
		IntRect blockRect = getCollisionRect();
		
		IntRect playerRect = player.getNextPosCollisionRect();
		
		return blockRect.intersects(playerRect);
		
	}
	
	/* (non-Javadoc)
	 * @see BlockInterface#draw(java.awt.Graphics, PlayerSprite, int, int)
	 */
	@Override
	public void draw(Graphics g, PlayerSprite player, int panelWidth, int panelHeight) {
		
		image.drawObject(g, panelWidth/2 + (xPos - player.getxPos()) , panelHeight/2 + (yPos - player.getyPos()));
		
	}
	
	/* (non-Javadoc)
	 * @see BlockInterface#draw(java.awt.Graphics, int, int, int, int)
	 */
	@Override
	public void draw(Graphics g, int playerX, int playerY, int panelWidth, int panelHeight) {
		
		image.drawObject(g, panelWidth/2 + (xPos - playerX) , panelHeight/2 + (yPos - playerY));
		
	}
	
	/* (non-Javadoc)
	 * @see BlockInterface#drawForInitialImage(java.awt.Graphics, int, int)
	 */
	public void drawForInitialImage(Graphics g, int tileWidth, int tileHeight) {
		
//		System.out.println("<><>DELME about to draw a block at " + xPos+ "," + yPos);
		
		image.drawObjectIgnoreBounds(g, xPos, yPos );
		
	}

	/* (non-Javadoc)
	 * @see BlockInterface#getxPos()
	 */
	@Override
	public int getxPos() {
		return xPos;
	}

	/* (non-Javadoc)
	 * @see BlockInterface#setxPos(int)
	 */
	@Override
	public void setxPos(int xPos) {
		this.xPos = xPos;
	}

	/* (non-Javadoc)
	 * @see BlockInterface#getyPos()
	 */
	@Override
	public int getyPos() {
		return yPos;
	}

	/* (non-Javadoc)
	 * @see BlockInterface#setyPos(int)
	 */
	@Override
	public void setyPos(int yPos) {
		this.yPos = yPos;
	}
	
	
	
	/* (non-Javadoc)
	 * @see BlockInterface#primeImage(java.awt.Graphics)
	 */
	@Override
	public void primeImage(Graphics g) {
		
		image.drawObject(g, -image.getDesiredWidth() * 2, -image.getDesiredHeight() * 2);
		
	}
	
	/* (non-Javadoc)
	 * @see BlockInterface#isPassThrough()
	 */
	@Override
	public boolean isPassThrough() {
		return isPassThrough;
	}
	
	/* (non-Javadoc)
	 * @see BlockInterface#getCollisionRectMinY()
	 */
	@Override
	public int getCollisionRectMinY() {
		return rectMinY;
	}
	
	/* (non-Javadoc)
	 * @see BlockInterface#getCollisionRectMaxY()
	 */
	@Override
	public int getCollisionRectMaxY() {
		return rectMaxY;
	}
	
	

	/* (non-Javadoc)
	 * @see BlockInterface#getCollisionRectMinX()
	 */
	@Override
	public int getCollisionRectMinX() {
		return rectMinX;
	}


	/* (non-Javadoc)
	 * @see BlockInterface#getCollisionRectMaxX()
	 */
	@Override
	public int getCollisionRectMaxX() {
		return rectMaxX;
	}


	/* (non-Javadoc)
	 * @see BlockInterface#getWidth()
	 */
	@Override
	public int getWidth() {
		return width;
	}

	/* (non-Javadoc)
	 * @see BlockInterface#getHeight()
	 */
	@Override
	public int getHeight() {
		return height;
	}
	
	/* (non-Javadoc)
	 * @see BlockInterface#isPlayerCurrentlyOnBlock(PlayerSprite)
	 */
	@Override
	public boolean isPlayerCurrentlyOnBlock(PlayerSprite player) {
		
		IntRect playerRect = player.getCurrentPosCollisionRect();
		IntRect blockRect = getCollisionRect();
		
		if(playerRect.getMaxX() < blockRect.getMinX() || playerRect.getMinX() > blockRect.getMaxX())
			return false;
		
		double difference = playerRect.getMaxY() + 1.0 - blockRect.getMinY();
		
//		System.err.println("<><>DELME player.getMaxY is: " + playerRect.getMaxY() + ", block's minY is: " + blockRect.getMinY());
		
		return difference < 1.0 && difference > -1.0;
		
	}
	
	/* (non-Javadoc)
	 * @see BlockInterface#isPlayerCurrentlyBonkedOnBlock(PlayerSprite)
	 */
	@Override
	public boolean isPlayerCurrentlyBonkedOnBlock(PlayerSprite player) {
		
		IntRect playerRect = player.getCurrentPosCollisionRect();
		IntRect blockRect = getCollisionRect();
		
		if(playerRect.getMaxX() < blockRect.getMinX() || playerRect.getMinX() > blockRect.getMaxX())
			return false;
		
		double difference = playerRect.getMinY() + 1.0 - blockRect.getMaxY();
		
//		System.err.println("<><>DELME player.getMinY is: " + playerRect.getMinY() + ", block's maxY is: " + blockRect.getMaxX());
		
		return difference < 1.0 && difference > -1.0;
		
	}
	
	/* (non-Javadoc)
	 * @see BlockInterface#getName()
	 */
	@Override
	public String getName() {
		return null;
	}
	
}
